import numpy as np
import matplotlib.pyplot as plt

# Задаём параметры
r = 2.0
phi = 40 * np.pi / 180

# Конец радиус-вектора
x = r * np.cos(phi)
y = r * np.sin(phi)

# Создание фигуры
fig, ax = plt.subplots(figsize=(4, 4))
ax.set_aspect('equal')

# Радиус-вектор
ax.arrow(0, 0, x, y, head_width=0.08, head_length=0.1,
         fc='royalblue', ec='royalblue', linewidth=2, length_includes_head=True)

# Подпись r — чуть в стороне
ax.text(x - 0.3, y - 0.1, r'$r$', fontsize=14, color='royalblue')

# Угол φ — дуга
angle_arc = np.linspace(0, phi, 100)
arc_radius = 0.5
arc_x = arc_radius * np.cos(angle_arc)
arc_y = arc_radius * np.sin(angle_arc)
ax.plot(arc_x, arc_y, color='darkred', linewidth=1)

# Подпись φ — около дуги
ax.text(arc_radius * 1.05, arc_radius * 0.4, r'$\varphi$', fontsize=14, color='darkred')

# Подписи осей
ax.set_xlabel(r'$x$', fontsize=14)
ax.set_ylabel(r'$y$', fontsize=14, rotation=0, labelpad=10)

# Убираем деления и сетку
ax.set_xticks([])
ax.set_yticks([])
ax.grid(False)

# Показываем только первый квадрант
ax.set_xlim(0, r + 1)
ax.set_ylim(0, r + 1)

# Убираем рамки сверху и справа
ax.spines['top'].set_visible(False)
ax.spines['right'].set_visible(False)

# Сохраняем
plt.tight_layout()
plt.savefig("complex_number_py.png", dpi=300)
# plt.show()
