import numpy as np
import matplotlib.pyplot as plt

# Параметры
t = np.linspace(0, 10, 400)  # Время от 0 до 10
x = 2 * t + 1                # Линейная функция x = 2t + 1

# Создаем фигуру и оси
fig, ax = plt.subplots(figsize=(3, 2))

# Рисуем график
ax.plot(x, t, color='royalblue', linewidth=2)

# Убираем деления и числовые метки осей
ax.set_xticks([])
ax.set_yticks([])

# Подписи осей
ax.set_xlabel(r'$x$', fontsize=14)
ax.set_ylabel(r'$t$', fontsize=14, rotation=0, labelpad=10)

# Убираем сетку и фон
ax.grid(False)
ax.set_facecolor('white')

# Оставляем только нижнюю и левую рамки (осевые линии)
ax.spines['top'].set_visible(False)
ax.spines['right'].set_visible(False)

# Сохраняем изображение
plt.tight_layout()
plt.savefig("time_linear_py.png", dpi=150)
# plt.show()
